/*++

INTEL CONFIDENTIAL
Copyright 2007-2015 Intel Corporation All Rights Reserved.

The source code contained or described herein and all documents
related to the source code ("Material") are owned by Intel Corporation
or its suppliers or licensors. Title to the Material remains with
Intel Corporation or its suppliers and licensors. The Material
contains trade secrets and proprietary and confidential information of
Intel or its suppliers and licensors. The Material is protected by
worldwide copyright and trade secret laws and treaty provisions. No
part of the Material may be used, copied, reproduced, modified,
published, uploaded, posted, transmitted, distributed, or disclosed in
any way without Intel's prior express written permission.

No license under any patent, copyright, trade secret or other
intellectual property right is granted to or conferred upon you by
disclosure or delivery of the Materials, either expressly, by
implication, inducement, estoppel or otherwise. Any license under such
intellectual property rights must be express and approved by Intel in
writing.

File Name:
Common.h

Author:
Nisamudeen Shamsudeen
Scott Clements
Miguel Osorio

--*/
#ifndef __COMMON_H__
#define __COMMON_H__

#include <stdio.h>

#ifdef EFIX64


#include <atk_libc.h>
#include <shell.h>
#include <efilib.h>
#include <efiapi.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <efi_interface.h>
#include <efi.h>

#define bool BOOLEAN

#endif

#ifdef _DOS
#include <nal.h>
//#include <cudl.h>
#include <dos.h>

typedef unsigned char UCHAR;
typedef unsigned long DWORD;

#else
#ifndef EFIX64
#ifndef _LINUX
#ifndef IFR_PROJ
#include <winsock2.h>
#endif
#include <windows.h>
#endif //_LINUX
#endif
#endif


#ifdef _LINUX
#include "linux_types.h"
#endif

extern UINT32 g_fwuError;


enum errorValues {
    FWU_ERROR_SUCCESS,
    FWU_IME_NO_DEVICE = 8193,
    FWU_UPD_VER_MIS   = 8199,
    FWU_VER_GET_ERR = 8204,
    FWU_CERT_ERR = 8213,
    FWU_REBOOT_NEEDED = 8703,
    FWU_SKU_MISMATCH,
    FWU_VER_MISMATCH,
    FWU_SGN_MISMATCH,
    FWU_GENERAL,
    FWU_UPD_PROCESS,
    FWU_NO_MEMORY = 8710,
    FWU_AUTH = 8712,
    FWU_IMG_HEADER,
    FWU_FILE_OPEN,
    FWU_HTTP_ERROR,
    FWU_USAGE_ERROR,
    FWU_HOSTNAME,
    FWU_UPDATE_TIMEOUT,
    FWU_LOCAL_DIS,
    FWU_SECURE_DIS,
    FWU_IME_UN_SUP_MESS = 8722,
    FWU_NO_UPDATE,
    FWU_IME_NOT_READY,
    FWU_LAST_STATUS,
    FWU_GET_VER_ERR = 8727,
    FWU_IME_SMALL_BUFF,
    FWU_WSMAN_NO = 8734,
    FWU_UNSUPPRT_OS = 8740,
    FWU_ERROR_FW,
    FWU_HECI,
    FWU_UNSUPPRT_PLAT,
    FWU_VERIFY_OEM_ID_ERR,
    FWU_INVALID_OEM_ID = 8745,
    FWU_INVALID_IMG_LENGTH,
    FWU_GLBL_BUFF_UNAVAILABLE,
    FWU_INVALID_FW_PARAMS,
    FWU_AMT_STATUS_INTERNAL_ERROR,
    FWU_AMT_STATUS_NOT_READY = 8750,
    FWU_AMT_STATUS_INVALID_AMT_MODE,
    FWU_AMT_STATUS_INVALID_MESSAGE_LENGTH,
    FWU_SAVE_RESTORE_POINT_ERROR,
    FWU_FILE_WRITE,
    FWU_GET_BLIST_ERROR = 8755,
    FWU_CHECK_VERSION_ERROR,
    FWU_DISPLAY_FW_VERSION,
    FWU_IMAGE_UNDER_VCN,
    FWU_IMAGE_VER_HIST_CHK_FAIL,
    FWU_DOWNGRADE_VETOED = 8760,
    FWU_FW_WRITE_FILE_FAIL,
    FWU_FW_READ_FILE_FAIL,
    FWU_FW_DELETE_FILE_FAIL,
    FWU_PARTITION_LAYOUT_NOT_COMP,
    FWU_DOWNGRADE_NOT_ALLOWED_DATA_MISMATCH = 8765,
    FWU_UPDATE_PASSWORD_NOT_MATCHED,
    FWU_UPDATE_PASSWORD_EXCEED_MAXIMUM_RETRY,
    FWU_UPDATE_PASSWORD_NOT_PROVIDED,
    FWU_UPDATE_POLLING_FAILED,
    FWU_FILE_ALREADY_EXISTS = 8770,
    FWU_FILE_INVALID,
    FWU_USAGE_ERROR_B,
    FWU_AUDIT_POLICY_FAILURE,
    FWU_ERROR_CREATING_FT,
    FWU_SAL_NOTIFICATION_ERROR = 8775,
    FWU_UPD_IMG_LOADING,
    FWU_UPD_IMG_AUTHENTICATING,
    FWU_UPD_IMG_PROCESSING,
    FWU_UPD_CREATING_FT,
    FWU_UPD_UPDATING_CODE,
    FWU_UPD_UPDATING_NFT,
    FWU_FLASH_CODE_PARTITION_INVALID,
    FWU_FLASH_NFT_PARTITION_INVALID,
    FWU_ILLEGAL_IMAGE_LENGTH,
    FWU_HOST_RESET_REQUIRED,
    FWU_INVALID_GLUT,
    FWU_GET_PATTRIB_ERROR,
    FWU_GET_UPD_INFO_STATUS,
    FWU_PID_NOT_EXPECTED,
    FWU_UPDATE_INRECOVERY_MODE_RESTRICT_UPDATE_TO_ATTEMPTED_VERSION,
    FWU_BUFFER_COPY_FAILED,
    FWU_GET_ME_FWU_INFO,
    FWU_APP_REGISTER_OS_FAILURE,
    FWU_APP_UNREGISTER_OS_FAILURE,
    FWU_INVALID_PARTID,
    FWU_LIVE_PING_FAILURE,
    FWU_SERVICE_CONNECT_FAILURE,
    FWU_SERVICE_NOT_AVAILABLE,
    FWU_SERVICE_BUSY,
    FWU_USER_NOT_ADMIN,
    FWU_WMI_FAIL,
    FWU_CHK_BIT_LOCKER_FAIL,
    FWU_REG_CMD_FAIL,
    FWU_UPDATE_IMAGE_BLACKLISTED,
    FWU_DOWNGRADE_NOT_ALLOWED_SVN_RESTRICTION,
    FWU_INVALID_POINTER,
    FWU_UPV_VERSION_MISMATCHED,
    FWU_INSTID_IS_NOT_EXPECTED_ID,
    FWU_INFO_NOT_AVAILABLE,
    FWU_REJ_IPU_FULL_UPDATE_NEEDED,
    FWU_IPU_NAMEID_NOT_FOUND,
    FWU_RESTORE_POINT_INVALID,
    FWU_RESTORE_POINT_VALID_BUT_NOT_LATEST,
    FWU_RESTORE_POINT_OPERATION_NOT_ALLOWED,
    FWU_DOWNGRADE_NOT_ALLOWED_VCN_RESTRICTION,
    FWU_INVALID_SVN,
    FWU_OUT_OF_SVN_RESOURCES,
    FWU_REJECT_RESTORE_POINT_REQUEST_FLASH_IN_RECOVERY,
    FWU_REJECTED_BY_UPDATE_POLICY,
    FWU_REJECTED_INCOMPATIBLE_TOOL_USAGE,
    FWU_REJECTED_CROSSPOINT_UPDATE_NOT_ALLOWED,
    FWU_REJECTED_CROSSHOTFIX_UPDATE_NOT_ALLOWED,
    FWU_REJECTED_CURRENT_FW_NOT_ELIGIBLE_FOR_UPDATE,
    FWU_REJECTED_WRONG_UPDATE_OPERATION,
    FWU_REJECTED_WRONG_UPDATE_IMAGE_FOUND,
    FWU_REJECTED_IFR_UPDATE_NOT_ALLOWED,
    FWU_FAILURE_OCCURRED_DURING_ROLLBACK,
    FWU_RESTORE_POINT_OPERATION_FAILED,
    FWU_ERROR_DETECT_POWER_SOURCE,
    FWU_DISPLAY_PART_VERSION,
    FWU_PART_NOT_PRESENT,
    FWU_UNEXPECTED_SKU_TYPE,
    FWU_ERROR_GET_PLATFORM_TYPE,
    FWU_LAST_STATUS_CODE
};

typedef struct {
    UINT32 Cse_error_code;
    UINT32 Fwu_error_code;
} FwuCseErrorMap;

typedef struct {
    UINT32 Fwu_error_code;
    const char * Fwu_error_message;
} FwuCseErrorMsgMap;

typedef struct {
    UINT32 PchVer;
} HW_SKU;

#define HW_SKU_DEVICE_ID_MASK   0xFFFF0000
#define HW_SKU_REVISION_MASK    0x000000FF

typedef struct {
    UINT16 Major;
    UINT16 Minor;
    UINT16 Hotfix;
    UINT16 Build;
} FWVersion;

typedef struct {
    FWVersion code;
    FWVersion rcvy;
} FlashVersion;

#ifdef __cplusplus
extern "C" {
#endif

    UINT32 FromCseToFwuErrorCode(UINT32 cseer);
    const char * FromFwuErrorCodeToErrorMsg(UINT32 fwuer);

    // return < 0 if a < b
    //          0 if a = b
    //        > 0 if a > b
    int VersionCompare(FWVersion *a, FWVersion *b);



#ifndef EFIX64
#ifndef _LINUX
#ifndef _DOS
    BOOL WindowsReset( LPTSTR message );
#endif
#endif
#endif
#ifdef __cplusplus
}
#endif

#ifdef _WIN

#ifndef _LINUX

static const unsigned short DEFAULT_AMT_TCP_PORT = 16992;
static const unsigned short DEFAULT_AMT_TLS_PORT = 16993;

static const int MAX_LINE_LEN = 1024;
static const int TIMEOUT = 80;
static const char *DEFAULT_USERNAME = "admin";
static const char *DEFAULT_PASSWORD = "admin";

#endif //_LINUX
#endif // _WIN
#endif
